
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Sep 11 10:17:10 2007
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief description of this module 
   *
   *  \version MNG_ATP_TST.c#1:csrc:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_Mem.h"
#include "MNG_ATP_TST_Defines.h"
#include "MNG_TST_Utils.h"
#include "MNG_ATP_TST.h"
#include "MNG_ATP_TST_Specific_LCS.h"
#include "MNG_Functions.h"
#include "CRYS_RSA_Types.h"
#include "CRYS_RSA_PRIM.h"
#include "CRYS_RSA_BUILD.h"
#include "Init_CC.h"
#include "error.h"
#include "managment_error.h"
#include "lcs_error.h"
#include "sst.h"
#include "KMNG_Defs.h"
#include "KMNG_API.h"
#include "parser_err.h"

/************************ Defines *******************************/

/* canceling the lint warning:
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */

/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/
extern TST_MNG_PUBKey_TestDataStruct TST_MNG_OEMStaticPUBKey_TestData[];

/* AES data structs */
extern TST_MNG_RKEK_TestDataStruct TST_MNG_RKEK_TestData[];
/* HASH data struct */
extern TST_MNG_HASH_TestDataStruct TST_MNG_HASH_TestData[];

/* RSA data structs & variables */
extern TST_MNG_RSAKey_TestDataStruct TST_MNG_RSAKey_TestData[];
extern CRYS_RSAUserPrivKey_t       TST_MNGPrivKey;
extern CRYS_RSAUserPubKey_t        TST_MNGPubKey;
extern CRYS_RSAPrimeData_t         TST_MNGPrimData;
extern CRYS_RSAPrivUserContext_t   TST_MNGPrivCTX; 
extern CRYS_RSAPubUserContext_t    TST_MNGPubCTX;

/* SST required Buffers*/
extern DxUint8_t	TST_MNGSSTMainDBPool[TST_MNG_MAX_DATA_SIZE];
extern DxUint8_t	TST_MNGSSTSecondaryDBPool[TST_MNG_MAX_DATA_SIZE];

extern DxByte_t       TST_MNGWorkspace[TST_MNG_MAX_DATA_SIZE];
extern DxUint32_t     TST_MNGWorkspaceSizeInBytes;

/************* Private function prototype ***********************/
/************************ Public Functions ******************************/

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Set_LCS_To_Spec_Secure_State      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an Acceptance test for MNG APIs. 
 *  
 * Algorithm:       
 * 1. Get the current life cycle state, and verify it by calling DX_MNG_GetLCS
 *    API
 * 2. Set the RKEK with a known value by calling DX_MNG_SetRkekOtp API
 * 3. Set the OEM public key - to constant value by calling 
 *    DX_MNG_SetOemRsaPubKeyHashOtp API
 * 4. Change the LCS to the specific required LCS (through Device_manufacture 
 *    and secure states) by calling DX_MNG_ChangeLCS
 * 5. Verify legal operations on current state:
 *	  a. CRYS AES operation - Do AES Encrypt on data and verify the output is
 *       as expected
 *    b. CRYS HASH operation - Do HASH on data and verify that the output is 
 *       as expected
 *    c. CRYS RSA operation - Do RSA_PRIM_Encrypt and verify that the output
 *       is as expected 
 * 6. Verify illegal operations on current state
 *	  a. SST Operation - do SST get version and verify it fails
 *    b. SST Operation - do SST Init and verify it fails
 *    c. KMNG operation - do KMNG Init and verify that it fails
 *
 ******************************************************************************/                                

/*******************Need to move the function *****************************/

DxError_t MNG_ATP_TST_Set_LCS_To_Spec_Secure_State( void ) 
{

    /********* TST Variables Definitions ************/
    int                     TST_i = 0;
    DxError_t             	TST_Result = DX_SUCCESS, TST_TestStatus = DX_SUCCESS;    
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "MNG_ATP_TST_Set_LCS_To_Spec_Secure_State";    
    DxUint8_t               TST_LCSState = TST_MNG_CHIP_MANUFACTURE_STATE;
    DxUint32_t              TST_ReturnedLCS = 0;   
    SSTVersion_t			TST_MNGSSTVersion;
    CRYS_AES_KeySize_t		TST_AESKeySize = CRYS_AES_Key256BitSize;
   
    
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"********************************************************************* \n"));
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"** MNG_ATP_TST_Set_LCS_To_Spec_Secure_State Tests ******************* \n"));      
    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"********************************************************************* \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    /* Get the current state and verify it */ 
    /*-------------------------------------*/
    TST_Result = DX_MNG_GetLCS(&TST_ReturnedLCS);
    TST_TestStatus = MNG_TST_CheckErrorReturn_Expected(TST_Result, DX_SUCCESS, "DX_MNG_GetLCS",
    												   "", TST_MasterTestName);        
    if (TST_TestStatus != MNG_TEST_PASS) 
        return MNG_TEST_FAIL;
    
        
    if (TST_ReturnedLCS != TST_LCSState)
    {
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!! TST_Error - Current LCS is different than expected \n"));    
        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"Current LCS is %d, expected LCS is - %d \n",TST_ReturnedLCS,  TST_LCSState));            
        return MNG_TEST_FAIL;            
    }
    
    /* Set the RKEK with a known value */
    /*---------------------------------*/
    TST_Result = DX_MNG_SetRkekOtp(TST_MNG_RKEK_TestData[0].TST_KeyLen,
                                   TST_MNG_RKEK_TestData[0].TST_Key);
                                     
    TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Result,
                                              "DX_MNG_SetRkekOtp",
                                              TST_MNG_RKEK_TestData[0].TST_Name,
                                              TST_MasterTestName);
                                                    
    /* Change the LCS to the specific required LCS (through Device_manufacture and secure states) */ 
    /*--------------------------------------------------------------------------------------------*/
    for (TST_i = 0; TST_i < TST_MNG_MAX_NUM_OF_STATES-1; TST_i ++)
    {
    	if (TST_LCSState == TST_MNG_DEVICE_MANUFACTURE_STATE)
        {
        	/* Set the OEM public key - to constant value */
		      TST_Result = DX_MNG_SetOemRsaPubKeyHashOtp(TST_MNG_OEMStaticPUBKey_TestData[0].TST_E, 
		                                                 TST_MNG_OEMStaticPUBKey_TestData[0].TST_NLen,
		                                                 TST_MNG_OEMStaticPUBKey_TestData[0].TST_N);
		                                                 
		      TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Result,
		                                                "DX_MNG_SetOemRsaPubKeyHashOtp",
		                                                TST_MNG_OEMStaticPUBKey_TestData[0].TST_Name,
		                                                TST_MasterTestName);
		                                                 
		      if (TST_TestStatus != DX_SUCCESS)
		        return MNG_TEST_FAIL;
        }
    	
    	/* Set the next LCS variable */
	    switch (TST_i)
	    {
	    	case TST_MNG_LCS_CHIP_MANUFACTURE_IDX:
	    		TST_LCSState = TST_MNG_DEVICE_MANUFACTURE_STATE;
	    		break;
	    	case TST_MNG_LCS_DEVICE_MANUFACTURE_IDX:
	    		TST_LCSState = TST_MNG_SECURE_STATE;
	    		break;
	    	case TST_MNG_LCS_SECURITY_DISABLE_IDX:
	    		/* In this case it represents secure state */
	    		TST_LCSState = TST_MNG_SPEC_SECURE_MODE;
	    		break;
	    	default:
	    		break;
	    }
    	
    	/* Change to the next LCS */
    	TST_Result = DX_MNG_ChangeLCS(TST_LCSState);                                                                        	
    	TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Result,
	                                           	  "DX_MNG_ChangeLCS",
	                                          	  TST_MNG_RKEK_TestData[0].TST_Name,
	                                          	  TST_MasterTestName);                                             
		if (TST_TestStatus != DX_SUCCESS)
			return MNG_TEST_FAIL;
	
	    /* SW reset - Reset the SEP and initialize it, only relevant in debug mode */
	    TST_Result = MNG_TST_Reset_SEP();
	    if (TST_Result != DX_SUCCESS)
	    	return MNG_TEST_FAIL;	
	    
	    /* Verify the LCS */
	    TST_Result = DX_MNG_GetLCS(&TST_ReturnedLCS);
	    TST_TestStatus = MNG_TST_CheckErrorReturn_Expected(TST_Result, DX_SUCCESS, "DX_MNG_GetLCS",
	    												   "", TST_MasterTestName);        
	    if (TST_TestStatus != MNG_TEST_PASS) 
	        return MNG_TEST_FAIL;
	    
	        
	    if (TST_ReturnedLCS != TST_LCSState)
	    {
	        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!! TST_Error - Current LCS is different than expected \n"));    
	        MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"Current LCS is %d, expected LCS is - %d \n",TST_ReturnedLCS,  TST_LCSState));            
	        return MNG_TEST_FAIL;            
	    }
	    			
	    		
    }   
    
    /* Verify legal operations on current state */ 
    /*------------------------------------------*/
	/* CRYS AES operation */
	/**********************/
	/* AES Encrypt data */
	TST_Result = CRYS_AES(TST_MNG_RKEK_TestData[0].TST_IvCounter,
                          TST_MNG_RKEK_TestData[0].TST_Key,
                          TST_AESKeySize,
                          CRYS_AES_Encrypt,
                          TST_MNG_RKEK_TestData[0].TST_Mode,
                          TST_MNG_RKEK_TestData[0].TST_Data, 
                          TST_MNG_RKEK_TestData[0].TST_DataLen, 
                          TST_MNG_RKEK_TestData[0].TST_Output); 
	TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Result,
                                           	  "CRYS_AES",
                                          	  TST_MNG_RKEK_TestData[0].TST_Name,
                                          	  TST_MasterTestName);                                             
	if (TST_TestStatus != DX_SUCCESS)
		return MNG_TEST_FAIL;
	
	/* Verify the output is as expected */
	TST_Result = DX_VOS_MemCmp(TST_MNG_RKEK_TestData[0].TST_Output, TST_MNG_RKEK_TestData[0].TST_ExpectedOutput,
							   TST_MNG_RKEK_TestData[0].TST_DataLen);
	if (TST_Result != DX_SUCCESS)
	{
		MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!! TST_Error - AES output comparison failed \n"));    
	    return MNG_TEST_FAIL;
	}
		
	/* CRYS HASH operation */
	/***********************/
	/* Do HASH operation */
	TST_Result = CRYS_HASH(TST_MNG_HASH_TestData[0].TST_OperationMode,
                              TST_MNG_HASH_TestData[0].TST_input_data,
                              TST_MNG_HASH_TestData[0].TST_input_dataSize,
                              TST_MNG_HASH_TestData[0].TST_HashResultBuff);                              
	TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Result,
                                           	  "CRYS_HASH",
                                          	  TST_MNG_HASH_TestData[0].TST_Name,
                                          	  TST_MasterTestName);                                             
	if (TST_TestStatus != DX_SUCCESS)
		return MNG_TEST_FAIL;
	
	/* Verify the output is as expected */
	TST_Result = DX_VOS_MemCmp((DxUint8_t*)TST_MNG_HASH_TestData[0].TST_HashResultBuff, 
							   TST_MNG_HASH_TestData[0].TST_SHA1_Expected_output_data,
							   TST_MNG_HASH_TestData[0].TST_SHA1_Expected_dataSize);
	if (TST_Result != DX_SUCCESS)
	{
		MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!! TST_Error - HASH output comparison failed \n"));    
	    return MNG_TEST_FAIL;
	}
	
	
	/* CRYS RSA operation */
	/**********************/	
	/* Build the RSA public Key */               
    TST_Result = CRYS_RSA_Build_PubKey(&TST_MNGPubKey,
                                       TST_MNG_RSAKey_TestData[0].TST_E,
                                       TST_MNG_RSAKey_TestData[0].TST_ELen,
                                       TST_MNG_RSAKey_TestData[0].TST_N,
                                       TST_MNG_RSAKey_TestData[0].TST_NLen);
	TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Result,
	                                       	  "CRYS_RSA_Build_PubKey",
	                                      	  TST_MNG_RSAKey_TestData[0].TST_Name,
	                                      	  TST_MasterTestName);                                             
	if (TST_TestStatus != DX_SUCCESS)
		return MNG_TEST_FAIL;
                             
	/* Do RSA PRIM Encrypt operation */                                                    
	TST_Result = CRYS_RSA_PRIM_Encrypt(&TST_MNGPubKey,
                                       &TST_MNGPrimData,
                                       TST_MNG_RSAKey_TestData[0].TST_Data,
                                       TST_MNG_RSAKey_TestData[0].TST_NLen,
                                       TST_MNG_RSAKey_TestData[0].TST_Output);                                                                                                                
	TST_TestStatus = MNG_TST_CheckErrorReturn(TST_Result,
	                                       	  "CRYS_RSA_PRIM_Encrypt",
	                                      	  TST_MNG_RSAKey_TestData[0].TST_Name,
	                                      	  TST_MasterTestName);                                             
	if (TST_TestStatus != DX_SUCCESS)
		return MNG_TEST_FAIL;
	
	/* Verify the output is as expected */
	TST_Result = DX_VOS_MemCmp(TST_MNG_RSAKey_TestData[0].TST_ExpectedOutput, 
							   TST_MNG_RSAKey_TestData[0].TST_Output,
							   TST_MNG_RSAKey_TestData[0].TST_NLen);
	if (TST_Result != DX_SUCCESS)
	{
		MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!! TST_Error - RSA output comparison failed \n"));    
	    return MNG_TEST_FAIL;
	}
	
	
	/* Verify illegal operations on current state */
	/*--------------------------------------------*/
	/* SST Operation */
	/*****************/
	/* SST get version - should fail */
	TST_Result = SST_VersionGet(&TST_MNGSSTVersion);
	TST_TestStatus = MNG_TST_CheckErrorReturn_Expected(TST_Result,
													   DX_SEP_PARSER_WRONG_LCS_ERROR,
	                                       	  		   "SST_VersionGet",
	                                      	  		   "",
	                                      	  		   TST_MasterTestName);
	if (TST_TestStatus != DX_SUCCESS)
		return MNG_TEST_FAIL;
	
	/* SST Init - should fail */
	TST_Result = SST_Init((DxNvsMemoryId_t)TST_MNGSSTMainDBPool,
				          (DxNvsMemoryId_t)TST_MNGSSTSecondaryDBPool,
						  DX_NULL,
						  TST_MNGWorkspace,
						  TST_MNGWorkspaceSizeInBytes);
	TST_TestStatus = MNG_TST_CheckErrorReturn_Expected(TST_Result,
													   DX_SEP_PARSER_WRONG_LCS_ERROR,
	                                       	  		   "SST_Init",
	                                      	  		   "",
	                                      	  		   TST_MasterTestName);
	if (TST_TestStatus != DX_SUCCESS)
		return MNG_TEST_FAIL;						  
	
	/* KMNG operation */
	/******************/
	/* KMNG Init - should fail */
	TST_Result = KMNG_Init();
	TST_TestStatus = MNG_TST_CheckErrorReturn_Expected(TST_Result,
													   DX_SEP_PARSER_WRONG_LCS_ERROR,
	                                       	  		   "KMNG_Init",
	                                      	  		   "",
	                                      	  		   TST_MasterTestName);
	if (TST_TestStatus != DX_SUCCESS)
		return MNG_TEST_FAIL;

   	
   	return MNG_TEST_PASS;     
                  
}/* End of MNG_ATP_TST_Set_LCS_To_Spec_Secure_State*/ 


/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/




